<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package AffBox
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Delete plugin options.
delete_option( 'affbox_settings' );
delete_option( 'affbox_last_sync' );
delete_option( 'affbox_migrated_to_products' );

// Delete all affiliate product posts and their meta.
global $wpdb;

// Delete all affiliate products.
$affbox_products = get_posts(
	array(
		'post_type'   => 'affiliate_product',
		'post_status' => 'any',
		'numberposts' => -1,
		'fields'      => 'ids',
	)
);

if ( $affbox_products ) {
	foreach ( $affbox_products as $affbox_product_id ) {
		wp_delete_post( $affbox_product_id, true ); // true = force delete, bypass trash.
	}
}

// Delete any remaining post meta (in case some weren't deleted by wp_delete_post).
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Direct query is necessary for bulk deletion in uninstall.
$wpdb->query( $wpdb->prepare( "DELETE FROM $wpdb->postmeta WHERE meta_key LIKE %s", '\_affprod\_%' ) );

// Also clean up any legacy meta keys that might still exist.
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Direct query is necessary for bulk deletion in uninstall.
$wpdb->query( $wpdb->prepare( "DELETE FROM $wpdb->postmeta WHERE meta_key LIKE %s", '\_affbox\_%' ) );

// Clear any cached data if using a caching plugin.
if ( function_exists( 'wp_cache_flush' ) ) {
	wp_cache_flush();
}
