<?php
/**
 * Plugin Name: AffiliateBoxes.com Integration
 * Plugin URI: https://affiliateboxes.com/
 * Description: Display affiliate products from affiliateboxes.com in your WordPress site
 * Version: 1.0.0
 * Author: AffiliateBoxes.com
 * Author URI: https://affiliateboxes.com/
 * Text Domain: affbox
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * License: GPLv3
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 *
 * @package AffBox
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Define plugin constants.
if ( ! defined( 'AFFBOX_VERSION' ) ) {
	define( 'AFFBOX_VERSION', '1.0.0' );
}

if ( ! defined( 'AFFBOX_PLUGIN_DIR' ) ) {
	define( 'AFFBOX_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'AFFBOX_PLUGIN_URL' ) ) {
	define( 'AFFBOX_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

// Register the every_minute cron schedule early, before Action Scheduler loads.
// Action Scheduler registers this in its QueueRunner::init() on the 'init' hook,
// but WP-Cron may try to reschedule events before that hook fires.
add_filter(
	'cron_schedules',
	function ( $schedules ) {
		if ( ! isset( $schedules['every_minute'] ) ) {
			$schedules['every_minute'] = array(
				'interval' => 60,
				'display'  => __( 'Every Minute', 'affbox' ),
			);
		}
		return $schedules;
	}
);

// Load composer autoloader for Action Scheduler.
if ( file_exists( AFFBOX_PLUGIN_DIR . 'vendor/autoload.php' ) ) {
	require_once AFFBOX_PLUGIN_DIR . 'vendor/autoload.php';
}

// Initialize Action Scheduler.
if ( file_exists( AFFBOX_PLUGIN_DIR . 'vendor/woocommerce/action-scheduler/action-scheduler.php' ) ) {
	require_once AFFBOX_PLUGIN_DIR . 'vendor/woocommerce/action-scheduler/action-scheduler.php';
}

// Include required files.
$affbox_includes = array(
	'includes/class-affbox-logger.php',
	'includes/class-affbox.php',
	'includes/class-affbox-utils.php',
	'includes/class-affbox-action-scheduler.php',
	'admin/class-affbox-admin.php',
	'public/class-affbox-public.php',
);

foreach ( $affbox_includes as $affbox_file ) {
	$affbox_filepath = AFFBOX_PLUGIN_DIR . $affbox_file;
	if ( file_exists( $affbox_filepath ) ) {
		require_once $affbox_filepath;
	} elseif ( defined( 'WP_DEBUG' ) && WP_DEBUG ) {
		// Log error if file is missing - use error_log here since AffBox_Logger may not be loaded yet.
		// phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log -- Debug logging only, logger not yet available.
		error_log( sprintf( 'AffBox Error: Cannot find file at path %s', $affbox_filepath ) );
	}
}

/**
 * Initialize the plugin.
 */
function affbox_run() {
	if ( class_exists( 'AffBox' ) ) {
		$plugin = new AffBox();
		$plugin->run();
	} else {
		add_action(
			'admin_notices',
			function () {
				?>
			<div class="notice notice-error">
				<p><?php esc_html_e( 'Error: AffBox class not found. Plugin activation failed.', 'affbox' ); ?></p>
			</div>
				<?php
			}
		);
	}
}

// Initialize the plugin after WordPress is fully loaded.
add_action( 'plugins_loaded', 'affbox_run' );

// Register activation hook for migration.
register_activation_hook( __FILE__, array( 'AffBox', 'activate' ) );

// Register deactivation hook.
register_deactivation_hook( __FILE__, array( 'AffBox', 'deactivate' ) );
