<?php
/**
 * Admin products list partial.
 *
 * @package affbox
 */

defined( 'ABSPATH' ) || exit;

// Products and boxes are treated the same for display.
$affbox_products = get_posts(
	array(
		'post_type'      => 'affiliate_product',
		'post_status'    => 'publish',
		'posts_per_page' => -1,
		'orderby'        => 'title',
		'order'          => 'ASC',
		'meta_query'     => array( // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query
			array(
				'key'     => '_affprod_type',
				'value'   => array( 'product', 'box' ),
				'compare' => 'IN',
			),
		),
	)
);

$affbox_tables = get_posts(
	array(
		'post_type'      => 'affiliate_product',
		'post_status'    => 'publish',
		'posts_per_page' => -1,
		'orderby'        => 'title',
		'order'          => 'ASC',
		'meta_query'     => array( // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query
			array(
				'key'     => '_affprod_type',
				'value'   => 'table',
				'compare' => '=',
			),
		),
	)
);

$affbox_total_products = count( $affbox_products );
$affbox_total_tables   = count( $affbox_tables );
?>

<h5 class="card-title">
	<i class="bi bi-basket me-2 text-primary"></i>
	<?php esc_html_e( 'Available Products', 'affbox' ); ?>
</h5>
<p class="text-muted">
	<?php
	echo esc_html(
		sprintf(
			/* translators: %d: number of products */
			_n(
				'%d product available for this website',
				'%d products available for this website',
				$affbox_total_products,
				'affbox'
			),
			$affbox_total_products
		)
	);
	?>
	&ndash;
	<a href="https://affiliateboxes.com/products/" target="_blank" rel="noopener">
		<?php esc_html_e( 'View all products', 'affbox' ); ?>
		<i class="bi bi-box-arrow-up-right ms-1"></i>
	</a>
</p>

<?php if ( ! empty( $affbox_products ) ) : ?>
	<div class="table-responsive">
		<table class="table table-hover align-middle table-responsive-stack">
			<thead>
				<tr>
					<th scope="col"><?php esc_html_e( 'Product Name', 'affbox' ); ?></th>
					<th scope="col" class="column-shortcode"><?php esc_html_e( 'Shortcode', 'affbox' ); ?></th>
					<th scope="col" class="column-last_updated"><?php esc_html_e( 'Last Updated', 'affbox' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ( $affbox_products as $affbox_product ) : ?>
					<?php
					$affbox_product_slug = get_post_meta( $affbox_product->ID, '_affprod_slug', true );
					$affbox_last_updated = get_post_meta( $affbox_product->ID, '_affprod_last_synced', true );
					$affbox_identifier   = esc_html( get_post_meta( $affbox_product->ID, '_affprod_identifier', true ) );
					?>
					<tr>
						<td data-label="<?php esc_attr_e( 'Product', 'affbox' ); ?>">
							<a href="https://affiliateboxes.com/products/<?php echo esc_attr( $affbox_product_slug ); ?>/" target="_blank" rel="noopener" title="<?php echo esc_attr__( 'Edit product on affiliateboxes.com', 'affbox' ); ?>">
								<?php echo esc_html( $affbox_product->post_title ); ?>
								<i class="bi bi-box-arrow-up-right ms-1"></i>
							</a>
						</td>
						<td data-label="<?php esc_attr_e( 'Shortcode', 'affbox' ); ?>">
							<span class="affbox-copy-shortcode" data-shortcode="[affprod slug='<?php echo esc_attr( $affbox_product_slug ); ?>']" title="<?php echo esc_attr__( 'Copy shortcode', 'affbox' ); ?>" tabindex="0">
								<code>[affprod slug="<?php echo esc_attr( $affbox_product_slug ); ?>"]</code>
							</span>

							<?php if ( $affbox_identifier ) : ?>
								<br>
								<span class="affbox-copy-shortcode" data-shortcode="[affprod identifier='<?php echo esc_attr( $affbox_identifier ); ?>']" title="<?php echo esc_attr__( 'Copy identifier shortcode', 'affbox' ); ?>" tabindex="0">
									<code>[affprod identifier="<?php echo esc_attr( $affbox_identifier ); ?>"]</code>
								</span>
							<?php endif; ?>
						</td>
						<td data-label="<?php esc_attr_e( 'Last Updated', 'affbox' ); ?>">
							<?php
							if ( $affbox_last_updated ) {

								$affbox_timestamp = strtotime( $affbox_last_updated );
								$affbox_now       = time() + (int) ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS );
								$affbox_diff      = $affbox_now - $affbox_timestamp;

								if ( $affbox_diff < 60 ) {
									echo esc_html__( 'Just now', 'affbox' );

								} elseif ( $affbox_diff < DAY_IN_SECONDS * 30 ) {
									echo esc_html(
										sprintf(
											/* translators: %s: Human-readable time difference, e.g. "2 hours". */
											__( '%s ago', 'affbox' ),
											human_time_diff( $affbox_timestamp, $affbox_now )
										)
									);

								} else {
									echo esc_html(
										date_i18n(
											get_option( 'date_format' ) . ' ' . get_option( 'time_format' ),
											$affbox_timestamp
										)
									);
								}
							} else {
								esc_html_e( 'Never', 'affbox' );
							}
							?>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
	</div>
<?php else : ?>
	<p class="text-muted"><?php esc_html_e( 'No products found.', 'affbox' ); ?></p>
<?php endif; ?>

<hr class="my-4">

<h5 class="card-title">
	<i class="bi bi-table me-2 text-primary"></i>
	<?php esc_html_e( 'Available Tables', 'affbox' ); ?>
</h5>
<p class="text-muted">
	<?php
	echo esc_html(
		sprintf(
			/* translators: %d: number of tables */
			_n(
				'%d table available for this website',
				'%d tables available for this website',
				$affbox_total_tables,
				'affbox'
			),
			$affbox_total_tables
		)
	);
	?>
	&ndash;
	<a href="https://affiliateboxes.com/tables/" target="_blank" rel="noopener">
		<?php esc_html_e( 'View all tables', 'affbox' ); ?>
		<i class="bi bi-box-arrow-up-right ms-1"></i>
	</a>
</p>

<?php if ( ! empty( $affbox_tables ) ) : ?>
	<div class="table-responsive">
		<table class="table table-hover align-middle table-responsive-stack">
			<thead>
				<tr>
					<th scope="col"><?php esc_html_e( 'Table Name', 'affbox' ); ?></th>
					<th scope="col" class="column-shortcode"><?php esc_html_e( 'Shortcode', 'affbox' ); ?></th>
					<th scope="col" class="column-last_updated"><?php esc_html_e( 'Last Updated', 'affbox' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ( $affbox_tables as $affbox_table_item ) : ?>
					<?php
					$affbox_table_slug         = get_post_meta( $affbox_table_item->ID, '_affprod_slug', true );
					$affbox_table_last_updated = get_post_meta( $affbox_table_item->ID, '_affprod_last_synced', true );
					?>
					<tr>
						<td data-label="<?php esc_attr_e( 'Table', 'affbox' ); ?>">
							<a href="https://affiliateboxes.com/tables/<?php echo esc_attr( $affbox_table_slug ); ?>/" target="_blank" rel="noopener" title="<?php echo esc_attr__( 'Edit table on affiliateboxes.com', 'affbox' ); ?>">
								<?php echo esc_html( $affbox_table_item->post_title ); ?>
								<i class="bi bi-box-arrow-up-right ms-1"></i>
							</a>
						</td>
						<td data-label="<?php esc_attr_e( 'Shortcode', 'affbox' ); ?>">
							<span class="affbox-copy-shortcode" data-shortcode="[afftable slug='<?php echo esc_attr( $affbox_table_slug ); ?>']" title="<?php echo esc_attr__( 'Copy shortcode', 'affbox' ); ?>" tabindex="0">
								<code>[afftable slug="<?php echo esc_attr( $affbox_table_slug ); ?>"]</code>
							</span>
						</td>
						<td data-label="<?php esc_attr_e( 'Last Updated', 'affbox' ); ?>">
							<?php
							if ( $affbox_table_last_updated ) {

								$affbox_timestamp = strtotime( $affbox_table_last_updated );
								$affbox_now       = time() + (int) ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS );
								$affbox_diff      = $affbox_now - $affbox_timestamp;

								if ( $affbox_diff < 60 ) {
									echo esc_html__( 'Just now', 'affbox' );

								} elseif ( $affbox_diff < DAY_IN_SECONDS * 30 ) {
									echo esc_html(
										sprintf(
											/* translators: %s: Human-readable time difference, e.g. "2 hours". */
											__( '%s ago', 'affbox' ),
											human_time_diff( $affbox_timestamp, $affbox_now )
										)
									);

								} else {
									echo esc_html(
										date_i18n(
											get_option( 'date_format' ) . ' ' . get_option( 'time_format' ),
											$affbox_timestamp
										)
									);
								}
							} else {
								esc_html_e( 'Never', 'affbox' );
							}
							?>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
	</div>
<?php else : ?>
	<p class="text-muted"><?php esc_html_e( 'No tables found.', 'affbox' ); ?></p>
<?php endif; ?>
