<?php
/**
 * Admin display partial for AffBox.
 *
 * @package affbox
 */

defined( 'ABSPATH' ) || exit;
?>
<div class="wrap affbox-admin">
	<div class="affbox-loader" id="affbox-loader"></div>

	<div class="affbox-page-header">
		<img src="<?php echo esc_url( plugins_url( '../../assets/logo.webp', __FILE__ ) ); ?>" class="affbox-header-logo" alt="AffiliateBoxes Logo">
		<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
	</div>

	<?php
	$affbox_settings = get_option( 'affbox_settings', array() );
	$affbox_api_key  = isset( $affbox_settings['api_key'] ) ? $affbox_settings['api_key'] : '';

	if ( empty( $affbox_api_key ) ) :
		?>
		<div class="affbox-card card">
			<div class="card-body">
				<div class="text-center py-5">
					<div class="mb-4">
						<i class="bi bi-link-45deg display-1 text-muted" style="font-size: 3rem;"></i>
					</div>
					<h3><?php esc_html_e( 'Connect to AffiliateBoxes.com', 'affbox' ); ?></h3>
					<p class="text-muted mb-4"><?php esc_html_e( 'Clicking the button below will open AffiliateBoxes.com. Login to your account and click "Allow" for the Connection Request to connect your site to AffiliateBoxes.com.', 'affbox' ); ?></p>
					
					<div class="row justify-content-center">
						<div class="col-md-6">
							<div class="d-grid gap-2">
								<button type="button" class="btn btn-primary btn-lg" id="connect-site">
									<i class="bi bi-plug-fill me-2"></i>
									<?php esc_html_e( 'Connect Site', 'affbox' ); ?>
								</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
	else :
		?>
		<div class="affbox-card card">
			<div class="card-body">
				<div class="d-flex justify-content-between align-items-center mb-4">
					<div>
						<h3 class="mb-1"><?php esc_html_e( 'Connected', 'affbox' ); ?></h3>
						<p class="text-muted mb-0">
							<i class="bi bi-check-circle-fill text-success me-1"></i>
							<?php esc_html_e( 'Your site is linked to AffiliateBoxes.com', 'affbox' ); ?>
						</p>
					</div>

					<div id="queue-status-container" class="alert alert-info py-2 px-3 mb-0" style="display: none;">
						<div class="d-flex align-items-center">
							<div id="queue-status" class="me-3">
								<i class="bi bi-arrow-repeat bi-spin me-2"></i>
								<?php esc_html_e( 'Checking sync status...', 'affbox' ); ?>
							</div>
							<div id="queue-progress" class="small text-muted mb-0"></div>
						</div>
					</div>
				</div>
				<hr>
				<div id="affbox-available-products">
					<?php include AFFBOX_PLUGIN_DIR . 'admin/partials/affbox-admin-products-list.php'; ?>
				</div>
			</div>
		</div>

		<div class="affbox-card card mt-4">
			<div class="card-body">
				<h5 class="card-title"><?php esc_html_e( 'How to Use', 'affbox' ); ?></h5>

				<h6><?php esc_html_e( 'Using Gutenberg Block', 'affbox' ); ?></h6>
				<p class="text-muted"><?php esc_html_e( 'In the block editor, add an "AffiliateBoxes" block and select your desired product or table from the dropdown.', 'affbox' ); ?></p>
				<img src="<?php echo esc_url( plugins_url( '../../assets/block.png', __FILE__ ) ); ?>" class="img-fluid mb-4 border rounded affbox-img-shadow" alt="<?php esc_attr_e( 'Gutenberg Block', 'affbox' ); ?>">

				<h6><?php esc_html_e( 'Using Shortcodes', 'affbox' ); ?></h6>
				<p class="text-muted"><?php esc_html_e( 'To display an affiliate product in your posts or pages, use the following shortcode:', 'affbox' ); ?></p>
				<pre><code>[affprod slug="slug"]</code></pre>
				<p class="text-muted"><?php esc_html_e( 'The identifier is a field you can set to anything you want in the product settings, that way you can have a predictable shortcode:', 'affbox' ); ?></p>
				<pre><code>[affprod identifier="identifier"]</code></pre>

				<h6><?php esc_html_e( 'Using PHP', 'affbox' ); ?></h6>
				<p class="text-muted"><?php esc_html_e( 'To display an affiliate product in your theme files, use:', 'affbox' ); ?></p>
				<pre><code>&lt;?php echo do_shortcode('[affprod ...]'); ?&gt;</code></pre>

				<div class="mt-5 pt-4 border-top">
					<h6 class="text-danger"><?php esc_html_e( 'Danger Zone', 'affbox' ); ?></h6>
					<p class="text-muted small"><?php esc_html_e( "Manual syncing shouldn't be required. Changes are synced in automatically within minutes after saving any changes in your AffiliateBoxes.com account.", 'affbox' ); ?></p>
					<div class="btn-group">
						<button type="button" class="btn btn-outline-primary" id="sync-products">
							<i class="bi bi-arrow-repeat me-2"></i>
							<?php esc_html_e( 'Sync Now', 'affbox' ); ?>
						</button>
						<button type="button" class="btn btn-outline-danger" id="disconnect-site">
							<i class="bi bi-plug me-2"></i>
							<?php esc_html_e( 'Disconnect', 'affbox' ); ?>
						</button>
					</div>
				</div>
			</div>
		</div>
		<?php
	endif;
	?>

	<div class="mt-4 text-center">
		<p class="text-muted small">
			<?php
			$affbox_last_sync = get_option( 'affbox_last_sync' );
			if ( $affbox_last_sync ) {
				// translators: %s: last sync date/time.
				printf( esc_html__( 'Last synchronized: %s', 'affbox' ), esc_html( $affbox_last_sync ) );
			}
			?>
		</p>
	</div>

</div>
